//*********************************************************************************
// RAbout.cpp - The "About" box
//
// Half-Life Sprite Viewer - Written by David Flor, (c) 1999 Mach III Enterprises
//*********************************************************************************
// The "About" dialog, where everyone says who they are and the copyrights they 
//  hold...
//*********************************************************************************

#include "stdafx.h"
#include "sprview.h"

LRESULT CALLBACK AboutDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			char tStr[256], tStr2[256];

			GetWindowText(GetDlgItem(hDlg, IDC_VERSIONLINE), tStr, 255);
			sprintf(tStr2, tStr, VERSION);
			SetWindowText(GetDlgItem(hDlg, IDC_VERSIONLINE), tStr2);
			return TRUE;
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				case IDCANCEL:
					EndDialog(hDlg, LOWORD(wParam));
					return TRUE;
			}
			break;
		}
	}
    
	return FALSE;
}

